# 🛠️ **COMPLETE PARTS LIST: OpenSourceTerraCore TC-1 Food Synthesizer**
**Hybrid Pump + CoreXY System | Minimum Cost Edition**

---

## 📋 **CRITICAL SPECIFICATIONS BEFORE PARTS**
- **Footprint:** 600×500×400mm (countertop)
- **Power:** 110V/220V AC → 24V/12V/5V DC
- **Food Safety:** All food-contact parts FDA-approved
- **Build Volume:** 300×300×200mm (meal size)
- **Production Rate:** 3-5 meals/hour
- **Target Cost:** <$800 for core system

---

## 🔩 **SECTION 1: STRUCTURAL FRAME & CHASSIS**

### **A. Main Frame ($85)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 4 | 2020 Aluminum Extrusion | 600mm length | AliExpress | $28 |
| 4 | 2020 Aluminum Extrusion | 500mm length | AliExpress | $24 |
| 4 | 2020 Aluminum Extrusion | 400mm length | AliExpress | $20 |
| 32 | Corner Brackets | 90° with M5 holes | Amazon | $12 |
| 100 | M5×10mm Screws | Stainless steel | AliExpress | $8 |
| 100 | M5 T-nuts | For 2020 extrusion | AliExpress | $8 |

### **B. Panels & Enclosure ($45)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 1 | Acrylic Sheet | 600×500×3mm (clear) | Local supplier | $15 |
| 1 | Acrylic Sheet | 600×400×3mm (clear) | Local supplier | $12 |
| 2 | Acrylic Sheet | 500×400×3mm (clear) | Local supplier | $18 |
| 1 | Door Hinge | 300mm continuous piano | Amazon | $12 |
| 1 | Magnetic Door Catch | 5kg pull force | Amazon | $8 |

**Total Structure: $130**

---

## ⚙️ **SECTION 2: MOTION SYSTEM (CoreXY)**

### **A. Linear Motion ($75)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 4 | MGN12H Linear Rail | 400mm length | AliExpress | $40 |
| 8 | MGN12H Carriage | For above rails | AliExpress | $16 |
| 4 | Smooth Rod | 8mm×350mm stainless | AliExpress | $12 |
| 8 | LM8UU Bearings | 8mm ID linear bearings | Amazon | $7 |

### **B. Drive System ($60)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 3 | NEMA 17 Stepper | 1.8°, 40Ncm torque | AliExpress | $24 |
| 3 | TMC2209 Driver | SilentStepStick | AliExpress | $18 |
| 10m | GT2 Timing Belt | 6mm width | AliExpress | $8 |
| 6 | 20-tooth GT2 Pulley | 5mm bore | AliExpress | $6 |
| 4 | Idler Pulley | 20mm diameter | AliExpress | $4 |

**Total Motion: $135**

---

## 🧪 **SECTION 3: MATERIAL HANDLING SYSTEMS**

### **A. Mycelium Paste System ($45)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 1 | Direct Drive Extruder | BMG clone | AliExpress | $15 |
| 1 | NEMA 17 Stepper | 1.8° for extruder | AliExpress | $8 |
| 1 | Heated Nozzle | 1.2mm, 24V 40W | AliExpress | $12 |
| 2m | PTFE Tube | 4mm OD, 2mm ID | Amazon | $8 |
| 1 | Load Cell | 5kg capacity | AliExpress | $6 |
| 1 | HX711 Amplifier | For load cell | AliExpress | $2 |

### **B. Liquid System (Oil/Flavor) ($35)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 2 | 60ml Syringe | Luer lock, plastic | Medical supply | $4 |
| 2 | NEMA 11 Stepper | 0.9°, 12Ncm | AliExpress | $16 |
| 2 | 8mm Leadscrew | 300mm length | AliExpress | $6 |
| 2 | Leadscrew Nut | Bronze, for 8mm | AliExpress | $4 |
| 2 | Syringe Holder | 3D printed | DIY | $0.50 filament |
| 2 | Limit Switch | Mechanical endstop | AliExpress | $5 |

### **C. Powder System (Protein/Vitamins) ($28)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 1 | 12V DC Gear Motor | 30RPM, 5kg·cm | AliExpress | $8 |
| 1 | 6mm Auger | 200mm length (pasta maker part) | Amazon | $5 |
| 1 | Clear PETG Tube | 10mm ID, for auger | Local | $3 |
| 1 | Vibration Motor | 12V, from pager | Salvage | $2 |
| 1 | Powder Hopper | 500ml PET bottle | Recycle | $0 |
| 1 | Load Cell | 500g capacity | AliExpress | $6 |
| 1 | Anti-bridging Rod | 3mm steel rod | Hardware | $4 |

### **D. Color System (CMYK+W Gels) ($55)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 5 | Inkjet Cartridges | Epson 802 refillable | Amazon | $10 |
| 1 | 6-channel Pump | Peristaltic, 12V | AliExpress | $35 |
| 6m | Silicone Tubing | 2mm ID, food grade | Amazon | $8 |
| 1 | Mixing Manifold | 3D printed (PETG) | DIY | $2 filament |

### **E. Pasteurization System ($22)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 1 | Cartridge Heater | 24V, 100W | AliExpress | $8 |
| 2 | DS18B20 Sensor | Waterproof | AliExpress | $4 |
| 1m | Copper Tube | 8mm OD, 1mm wall | Hardware | $6 |
| 1 | Insulation Wrap | Fiberglass | Hardware | $4 |

**Total Material Handling: $185**

---

## 🔥 **SECTION 4: THERMAL & COOKING SYSTEM**

### **A. Heated Bed ($40)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 1 | Aluminum Plate | 300×300×4mm | Metals supplier | $15 |
| 1 | Silicone Heater | 24V, 200W, 300×300mm | AliExpress | $18 |
| 1 | Thermal Fuse | 120°C cutoff | AliExpress | $3 |
| 1 | PEI Sheet | 300×300mm with adhesive | Amazon | $8 |

### **B. Chamber Heating ($25)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 1 | Ceramic Heat Bulb | 100W, 110V | Amazon | $8 |
| 1 | Lamp Socket | E26 with guard | Hardware | $4 |
| 1 | Fan | 120mm, 12V | Computer salvage | $5 |
| 1 | SSR Relay | 25A, for heater control | AliExpress | $8 |

### **C. Temperature Monitoring ($15)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 3 | MAX6675 Module | K-type thermocouple | AliExpress | $9 |
| 3 | K-type Thermocouple | 300°C range | AliExpress | $6 |

**Total Thermal: $80**

---

## 💻 **SECTION 5: ELECTRONICS & CONTROL**

### **A. Main Controller ($65)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 1 | Raspberry Pi 4B | 2GB RAM (or Pi 5 if available) | Amazon | $45 |
| 1 | Arduino Mega 2560 | Clone version | AliExpress | $15 |
| 1 | MicroSD Card | 32GB, Class 10 | Amazon | $8 |
| 1 | 5V Power Supply | 3A, for Pi | AliExpress | $7 |

### **B. Power Distribution ($40)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 1 | 24V Power Supply | 10A, 240W | Mean Well LRS-350-24 | $25 |
| 1 | 12V Buck Converter | 5A, step-down | AliExpress | $6 |
| 1 | 5V Buck Converter | 3A, step-down | AliExpress | $5 |
| 1 | Terminal Block | 20-position | AliExpress | $4 |

### **C. User Interface ($35)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 1 | 7" Touchscreen | HDMI, 1024×600 | AliExpress | $30 |
| 1 | Rotary Encoder | with push button | AliExpress | $5 |

### **D. Wiring & Connectors ($25)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 10m | 18AWG Wire | Silicone insulated | Amazon | $12 |
| 20 | XT60 Connector | Male/female pairs | AliExpress | $8 |
| 50 | JST Connector | Various sizes | AliExpress | $5 |

### **E. Sensors ($30)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 2 | Door Sensor | Magnetic reed switch | AliExpress | $4 |
| 1 | Humidity Sensor | DHT22 | AliExpress | $6 |
| 1 | Current Sensor | ACS712 20A | AliExpress | $5 |
| 4 | Optical Endstop | Adjustable | AliExpress | $12 |
| 1 | Water Sensor | Conductivity type | AliExpress | $3 |

**Total Electronics: $195**

---

## 💧 **SECTION 6: FLUID & CLEANING SYSTEM**

### **A. Water Management ($35)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 1 | 12V Water Pump | 5L/min, food grade | AliExpress | $15 |
| 2 | Solenoid Valve | 12V, 1/4" NPT | AliExpress | $12 |
| 5m | Silicone Tubing | 6mm ID, food grade | Amazon | $8 |
| 1 | 5L Water Container | Food safe with lid | Recycle | $0 |

### **B. Drain & Waste ($18)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 1 | Drain Pump | 12V, diaphragm type | AliExpress | $10 |
| 1 | Waste Container | 2L with lid | Recycle | $0 |
| 2 | Quick Disconnect | 6mm barbed | AliExpress | $8 |

**Total Fluid: $53**

---

## 🧰 **SECTION 7: FASTENERS & CONSUMABLES**

### **A. Hardware Kit ($45)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 100 | M3×10mm Screws | Stainless | AliExpress | $8 |
| 100 | M3 Nuts | Stainless | AliExpress | $6 |
| 50 | M4×16mm Screws | Stainless | AliExpress | $7 |
| 50 | M4 Nuts | Stainless | AliExpress | $5 |
| 1 | Threadlocker | Blue medium | Hardware | $6 |
| 1 | Thermal Paste | 5 W/m·K | Amazon | $8 |
| 1 | Cable Ties | 100-pack | Amazon | $5 |

### **B. 3D Printing Filament ($25)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 2 | PETG Filament | 1kg, food grade | Amazon | $40 |
| *Note:* Only if you need to print parts yourself | | | | |

**Total Hardware: $70**

---

## 📦 **SECTION 8: CARTRIDGE SYSTEM (Consumables)**

### **A. Fuel Pods (Mycelium Blocks) ($20 setup)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 10 | 2L Plastic Containers | Food grade with lid | Restaurant supply | $10 |
| 1 | Substrate | 5kg straw/wood chips | Garden store | $8 |
| 1 | Spawn | Oyster mushroom | Online | $12 |

### **B. Nutrient Cartridges ($15 setup)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 10 | 100ml Bottles | PET with screw cap | Amazon | $8 |
| 1 | Pea Protein | 500g | Health food | $12 |
| 1 | Vitamin Mix | 100g | Online | $15 |

### **C. Color Gel Cartridges ($20 setup)**
| Qty | Part | Specs | Source | Est. Cost |
|-----|------|-------|--------|-----------|
| 5 | 50ml Bottles | For CMYK+W | Amazon | $6 |
| 1 | Food Color Set | Gel-based primary colors | Baking store | $14 |

**Total Consumables: $55** (one-time setup)

---

## 📊 **TOTAL COST SUMMARY**

| Section | Cost | % of Total |
|---------|------|------------|
| 1. Structure | $130 | 16.5% |
| 2. Motion | $135 | 17.1% |
| 3. Material Handling | $185 | 23.5% |
| 4. Thermal | $80 | 10.1% |
| 5. Electronics | $195 | 24.7% |
| 6. Fluid | $53 | 6.7% |
| 7. Hardware | $70 | 8.9% |
| 8. Consumables | $55 | 7.0% |
| **TOTAL** | **$887** | **100%** |

*Note: Actual cost may be 20% lower if salvaging parts*

---

## 🎯 **PRIORITY BUILD ORDER (Minimum Viable System)**

### **Phase 1: Core 3D Printer ($320)**
1. Frame & panels ($130)
2. Motion system ($135)
3. Basic electronics ($55) - Pi + drivers only

### **Phase 2: Food Printing Capability (+$285)**
4. Mycelium paste system ($45)
5. Thermal system ($80)
6. Liquid system ($35)
7. Powder system ($28)
8. Remaining electronics ($97)

### **Phase 3: Polish & Automation (+$282)**
9. Color system ($55)
10. Cleaning system ($53)
11. Cartridge system ($55)
12. All hardware ($70)
13. Final integration ($49)

---

## ⚡ **POWER REQUIREMENTS SUMMARY**

| Voltage | Current | Purpose |
|---------|---------|---------|
| 24V DC | 10A max | Heaters, main motors |
| 12V DC | 5A max | Pumps, fans, solenoids |
| 5V DC | 3A max | Electronics, sensors |
| 110/220V AC | 15A | Total system draw |

**Total Power:** ~500W peak, 200W average

---

## 🛠️ **ESSENTIAL TOOLS NEEDED**

| Tool | Purpose | Cost |
|------|---------|------|
| Hex key set | Assembly | $10 |
| Wire strippers | Electronics | $8 |
| Soldering iron | Electronics | $20 |
| Multimeter | Testing | $25 |
| Calipers | Precision measurement | $15 |
| Drill & bits | Mounting holes | $40 |
| **Total Tools** | | **$118** |

---

## 📦 **WHERE TO SOURCE (Priority Order)**

1. **AliExpress** - Motors, sensors, electronics (60% of parts)
2. **Amazon** - Fast shipping for critical items (20% of parts)
3. **Local hardware** - Structural materials, fasteners (10%)
4. **Salvage/recycle** - Containers, some electronics (10%)
5. **3D print yourself** - Custom brackets, holders (filament cost only)

---

## ⚠️ **CRITICAL FOOD SAFETY PARTS**

**Must be NEW (not salvaged):**
1. All food-contact tubing (silicone only)
2. Syringes (medical grade)
3. Containers for consumables
4. Heating elements (no unknown coatings)

**Can be salvaged:**
1. Structural metals
2. Electronics (if properly cleaned)
3. Mechanical parts (bearings, screws)
4. Power supplies

---

## 🔧 **ALTERNATIVE: PRE-BUILT OPTION**

If building from scratch is too complex:

**Buy:** Creality Ender 3 Pro ($200)
**Modify with:** 
- Dual extruder upgrade ($40)
- Heated chamber mod ($60)
- Paste extruder conversion ($30)
- Liquid/powder add-ons ($80)

**Total:** $410 for 80% functionality

---

## 🚀 **FIRST 10 PARTS TO ORDER**

1. **2020 aluminum extrusion** (all lengths) - Longest lead time
2. **NEMA 17 steppers** (x4) - Core motion
3. **Raspberry Pi 4** - Brains of operation
4. **24V power supply** - Powers everything
5. **Linear rails** (MGN12H) - Precision motion
6. **Heated bed & nozzle** - Cooking capability
7. **Silicone tubing** (various sizes) - Fluid handling
8. **TMC2209 drivers** (x6) - Quiet control
9. **Load cells** (x3) - Material verification
10. **DS18B20 sensors** (x5) - Temperature monitoring

---

## 📝 **BUILD WEEK SCHEDULE**

**Week 1:** Frame assembly, basic motion
**Week 2:** Electronics wiring, firmware setup
**Week 3:** Thermal systems, paste extruder
**Week 4:** Liquid/powder systems integration
**Week 5:** Color system, cleaning setup
**Week 6:** Calibration, testing with real food
**Week 7:** Recipe development, optimization
**Week 8:** Documentation, final adjustments

---

## ✅ **VERIFICATION CHECKLIST BEFORE FIRST FOOD TEST**

- [ ] All steppers move correctly
- [ ] Heaters reach target temps (±2°C)
- [ ] Pumps move water (not paste yet)
- [ ] Load cells read accurately (±1g)
- [ ] Door safety switches work
- [ ] Emergency stop functional
- [ ] Cleaning cycle runs completely
- [ ] Cartridge detection working
- [ ] No fluid leaks anywhere
- [ ] Software interface responsive

---

## 🆘 **COMMON PITFALLS & SOLUTIONS**

1. **Paste too thick** → Add 5-10% water to mycelium mix
2. **Powder clumping** → Add anti-caking agent (rice starch)
3. **Color bleeding** → Cool food before color application
4. **Cleaning incomplete** → Increase flush volume 20%
5. **Layer adhesion poor** → Increase bed temp 5°C
6. **Pump accuracy off** → Calibrate with water first

---

## 📚 **OPEN SOURCE FILES NEEDED**

1. **3D models for:**
   - Multi-toolhead carriage
   - Syringe pump mounts
   - Powder hopper adapter
   - Cartridge holders
   - Cable management clips

2. **Electronics:**
   - PCB design for sensor hub
   - Wiring diagram (PDF)
   - Pinout reference card

3. **Software:**
   - Custom Marlin configuration
   - Python control scripts
   - Web interface files
   - Recipe format specification

---

**This is EVERYTHING you need to build the OpenSourceTerraCore TC-1 Food Synthesizer.** Total Estimated investment: ~$900 + 50-100 hours of build time.
