# OpenSourceTerraCore™ Trademark Policy

## 📜 Introduction

The name **OpenSourceTerraCore™** and associated logos (collectively, the "OpenSourceTerraCore Marks") are trademarks used to identify the open-source solar food synthesis project and its associated goods, services, and community.

This policy outlines how you may and may not use the OpenSourceTerraCore Marks. The goal is to protect the integrity of the project while encouraging community participation and adoption.

## ✅ Permitted Uses (You Can Do This)

You are encouraged to use the OpenSourceTerraCore Marks in the following ways:

### 1. **Non-Commercial Referencing**
- Refer to the project by name in discussions, articles, and presentations
- Use the name when teaching about or explaining the technology
- Include the name in academic papers and research references

### 2. **Community Building**
- Create and run community forums, chat groups, or local meetups about TerraCore™
- Make videos, tutorials, or educational content about the project
- Translate project documentation while clearly attributing the source

### 3. **Personal Projects**
- Build your own devices based on the open-source TerraCore™ designs
- Refer to your personal build as "based on OpenSourceTerraCore™" or "OpenSourceTerraCore™-compatible"
- Share your modifications and improvements with the community

## ❌ Restricted Uses (Do Not Do This Without Permission)

### 1. **Commercial Use**
- You may **not** use "OpenSourceTerraCore" as the primary brand name for your own commercial products or services
- You may **not** create and sell "OpenSourceTerraCore" branded kits or devices without explicit permission
- You may **not** use the name in a way that suggests official endorsement or partnership

### 2. **Confusing or Misleading Uses**
- You may **not** use the name in a way that suggests you are the original creator
- You may **not** create domain names that could be confused with the official project (e.g., OpenSourceterracore-official.com, buy-OpenSourceterracore.net)
- You may **not** alter the logo or create derivative logos for your own use

### 3. **Illegal or Harmful Activities**
- You may **not** use the marks in connection with illegal, unethical, or harmful activities
- You may **not** use the marks in a way that damages the project's reputation

## 🔧 For Commercial Inquiries

If you're interested in commercial use of the OpenSourceTerraCore Marks, please:
1. Open an issue in this repository with the subject "Commercial Trademark Inquiry"
2. Describe your proposed use case and business model
3. Explain how your use will benefit the TerraCore community

We're open to partnerships that align with our mission of decentralized, sustainable food production.

## 🌱 Community Guidelines

When using the OpenSourceTerraCore name, please:
- Always include the ™ symbol on first reference: **OpenSourceTerraCore™**
- Clearly distinguish between official project resources and your own content
- Link back to this repository when referencing the project
- Follow the spirit of open-source collaboration

## ⚖️ Enforcement

We prefer to resolve issues through community dialogue. However, we will take appropriate action to protect the OpenSourceTerraCore Marks from misuse that could harm the project or confuse users.

## 📞 Contact

For trademark questions or permission requests:
- Open an issue in this repository
- Use the "Trademark" label for faster response

---

*This policy is part of the OpenSourceTerraCore™ project. Last updated: 23-SEP-2025*  
*This document is licensed under CC BY 4.0. The OpenSourceTerraCore™ name and logo are trademarks.*

<p>TerraCore™ is a trademark used under common law for the open-source solar food synthesis project. 
Unauthorized commercial use prohibited. See <a href="Trademark.md">Trademark Policy</a>.</p>
